﻿Imports System.ComponentModel
Imports System.Collections.ObjectModel

Public Class StudentBody
    Implements INotifyPropertyChanged

    Public Event PropertyChanged As PropertyChangedEventHandler Implements System.ComponentModel.INotifyPropertyChanged.PropertyChanged
    Private _school As String
    Private _students As New ObservableCollection(Of Student)()


    Public Property School() As String
        Set(ByVal value As String)
            If _school <> value Then
                _school = value
                OnPropertyChanged("School")
            End If
        End Set
        Get
            Return _school
        End Get
    End Property


    Public Property Students() As ObservableCollection(Of Student)
        Set(ByVal value As ObservableCollection(Of Student))
            If _students IsNot value Then
                _students = value
                OnPropertyChanged("Students")

            End If
        End Set
        Get
            Return _students
        End Get
    End Property


    Protected Overridable Sub OnPropertyChanged(ByVal propChanged As String)
        RaiseEvent PropertyChanged(Me, New PropertyChangedEventArgs(propChanged))
    End Sub
End Class